 ; Ŀ
 ;   Shag - find shape entities, and shapes embedded in blocks.            
 ;   Copyright 2001 by Rocket Software Ltd.                                
 ;                                                                         
 ;   If the shape file isn't found then the shapes are left blank, they    
 ;   can be erased using shag, then erase previous.  The entity data       
 ;   returned by entget is the same as it would be if the file was found,  
 ;   but the 2 group, the shape name, is missing.                          
 ;                                                                         
 ;   Shapes can occur in a drawing in three ways:                          
 ;   1. As loose entities.                                                 
 ;   2. As part of a block.                                                
 ;   3. As part of a linetype definition.                                  
 ;                                                                         
 ;   Sadly, the "Orange Shag" is not a Druid ritual but a type of rug.     
 ; 

 ; Ŀ
 ;   Ishp - see if a font contains shapes.                                 
 ;   Takes one argument, a font name.                                      
 ;   Returns T if it is a font, nil otherwise.                             
 ;   Shape fonts produce an entry in the style table which references      
 ;   the font but has an empty string instead of a name (2 . "") and       
 ;   which doesn't show up in the style dialog box.                        
 ; 
 (DEFUN ISHP (phnam / rewind stylt shapep)
  (setq rewind T)
  (while (and (setq stylt (tblnext "style" rewind))
              (null shapep))
         (setq rewind ())
         (if (and (= (cdr (assoc 3 stylt)) phnam)
                  (= (cdr (assoc 2 stylt)) ""))
             (setq shapep T)))
 shapep)
 ; Ŀ
 ;   Ishp end.                                                             
 ; 

 ; Ŀ
 ;   Linch - see if any linetypes contain characters/shapes.               
 ;   Takes no arguments, calls nothing, returns nothing.                   
 ;   Based on the better documented routine Lint.lsp.                      
 ; 
 (DEFUN LINCH (/ rewind cline ltnam tenam ltlist sub lent styl)
  (setq rewind T)
  (while (setq cline (tblnext "ltype" rewind))
         (setq ltnam (cdr (assoc 2 cline)))
         (setq tenam (tblobjname "ltype" ltnam))
         (setq ltlist (entget tenam))
         (setq ltlist (cdr ltlist)) ; ditch first = this list -1 group (ename)
         (while (setq sub (car ltlist))
                (setq ltlist (cdr ltlist))
                (if (= (type (cdr sub)) 'ENAME)
                    (progn
                         (setq lent (entget (cdr sub)))
                         (if (and (= (cdr (assoc 0 lent)) "STYLE")
                                  (setq styl (cdr (assoc 3 lent)))
                                  (ishp styl))
                             (prompt (strcat "Linetype " ltnam
                                             " contains shape font " styl))))))
         (setq rewind ()))
 (princ))
 ; Ŀ
 ;   Linch end.                                                            
 ; 

 ; Ŀ
 ;   Ch - Grdraw a set of crosshairs.                                      
 ;   Takes one argument, Pa, a centre point.                               
 ;   Calls Ci, Returns nothing.                                            
 ; 
 (DEFUN CH (pa / rad rad2 pb angg)
  (setq rad (/ (getvar "viewsize") 12))
  (ci pa (/ rad 2))
  (ci pa (* rad 0.875))
 ; Ŀ
 ;   Crosslines.                                                           
 ; 
  (setq rad2 (* rad 1.125))
  (grdraw (polar pa pi rad2) (polar pa 0 rad2) 7)
  (grdraw (polar pa (* pi 0.5) rad2) (polar pa (* pi 1.5) rad2) 7)
  (setq angg 0)
  (repeat 4
          (setq pb (polar pa angg (* rad 0.125)))
          (grdraw (polar pb (+ angg (/ pi 2)) (/ rad 16))
                  (polar pb (- angg (/ pi 2)) (/ rad 16)) 7)
          (setq pb (polar pa angg (/ rad 4)))
          (grdraw (polar pb (+ angg (/ pi 2)) (/ rad 8))
                  (polar pb (- angg (/ pi 2)) (/ rad 8)) 7)
          (setq pb (polar pa angg (* rad 0.375)))
          (grdraw (polar pb (+ angg (/ pi 2)) (/ rad 12))
                  (polar pb (- angg (/ pi 2)) (/ rad 12)) 7)
          (setq pb (polar pa angg (* rad 0.625)))
          (grdraw (polar pb (+ angg (/ pi 2)) (/ rad 12))
                  (polar pb (- angg (/ pi 2)) (/ rad 12)) 7)
          (setq pb (polar pa angg (* rad 0.75)))
          (grdraw (polar pb (+ angg (/ pi 2)) (/ rad 8))
                  (polar pb (- angg (/ pi 2)) (/ rad 8)) 7)
          (setq pb (polar pa angg rad))
          (grdraw (polar pb (+ angg (/ pi 2)) (/ rad 12))
                  (polar pb (- angg (/ pi 2)) (/ rad 12)) 7)
          (setq angg (+ angg (/ pi 2))))
 (princ))
 ; Ŀ
 ;   Ch end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine CI - grdraw circle maker.                                  
 ; 
 (DEFUN CI (pa radd / reps pa pa1 pa2 angg colo)
  (setq reps 32)
  (setq colo 7)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ci end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Shag - find loose shape entities.                          
 ; 
 (DEFUN SHAG (/ shnam ss rad enam entt num)
  (setq shnam (strcase (getstring
                          "\nShape to locate or <Return> for all shapes: ")))
  (setq num 0)
  (if (setq ss (ssget "X" (list (cons 0 "SHAPE"))))
      (progn
           (while (setq enam (ssname ss num))
                  (setq entt (entget enam))
                  (if (or (= (cdr (assoc 2 entt)) shnam)
                          (= shnam ""))
                      (progn
                           (setq num (1+ num))
                           (ch (cdr (assoc 10 entt))))
                      (ssdel enam ss)))))
  (write-line (strcat "Shapes found: " (itoa num)))
  (if ss (command "select" ss ""))
 (princ))
 ; Ŀ
 ;   Subroutine Shag end.                                                  
 ; 

 ; Ŀ
 ;   Shag.                                                                 
 ; 
 (DEFUN C:SHAG (/ bldata blnam blist rew enam etype shnam blist malist str
                                                                  sub shstr)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Step through the block tables and see if each block contains shapes.  
 ;   Make a list: ((block1 shape1 shape2 etc.) (block2 etc.))              
 ; 
  (setq rew t)
  (while (setq bldata (tblnext "block" rew))
         (setq blnam (cdr (assoc 2 bldata)))
         (setq blnam (strcat (strcase (substr blnam 1 1))
                             (strcase (substr blnam 2) t)))
         (setq blist ())
         (setq rew ())
         (setq enam (cdr (assoc -2 bldata)))
         (while enam
                (setq etype (cdr (assoc 0 (entget enam))))
                (if (= etype "SHAPE")
                    (progn
                         (setq shnam (cdr (assoc 2 (entget enam))))
                         (if (null shnam) (setq shnam "Unknown"))
                         (if (not (member shnam blist))
                             (setq blist (cons shnam blist)))))
                (setq enam (entnext enam)))
         (if blist
             (progn
                  (setq blist (cons blnam blist))
                  (setq malist (cons blist malist)))))
 ; Ŀ
 ;   Now print out the master list.                                        
 ; 
  (if (null malist) (prompt "No shapes found in block definitions."))
  (while malist
        (setq sub (car malist))
        (setq malist (cdr malist))
        (setq str (car sub))
        (setq sub (cdr sub))
        (setq str (strcat "Block " str " contains shape"
                              (if (> (length sub) 1) "s:" "")))
        (while (setq shstr (car sub))
               (setq sub (cdr sub))
               (setq str (strcat str " " shstr)))
        (write-line str))
 ; Ŀ
 ;   Call (shag) to find loose shapes.                                     
 ; 
  (shag)
 ; Ŀ
 ;   Call Linch to see if any linetypes have embedded characters which     
 ;   may be shapes.                                                        
 ; 
  (linch)
 (princ))